// Generated by CoffeeScript 1.10.0
(function() {
  var Commands, commandDescriptions, defaultKeyMappings, root,
    slice = [].slice;

  Commands = {
    init: function() {
      var command, description, results;
      results = [];
      for (command in commandDescriptions) {
        description = commandDescriptions[command];
        results.push(this.addCommand(command, description[0], description[1]));
      }
      return results;
    },
    availableCommands: {},
    keyToCommandRegistry: {},
    addCommand: function(command, description, options) {
      if (command in this.availableCommands) {
        console.log(command, "已经被定义过！请检查重复命令。");
        return;
      }
      options || (options = {});
      return this.availableCommands[command] = {
        description: description,
        isBackgroundCommand: options.background,
        passCountToFunction: options.passCountToFunction,
        noRepeat: options.noRepeat,
        repeatLimit: options.repeatLimit
      };
    },
    mapKeyToCommand: function(arg) {
      var command, key, options;
      key = arg.key, command = arg.command, options = arg.options;
      if (!this.availableCommands[command]) {
        console.log(command, "不存在！");
        return;
      }
      if (options == null) {
        options = [];
      }
      return this.keyToCommandRegistry[key] = extend({
        command: command,
        options: options
      }, this.availableCommands[command]);
    },
    normalizeKey: function(key) {
      return key.replace(/<[acm]-/ig, function(match) {
        return match.toLowerCase();
      }).replace(/<([acm]-)?([a-zA-Z0-9]{2,5})>/g, function(match, optionalPrefix, keyName) {
        return "<" + (optionalPrefix ? optionalPrefix : "") + keyName.toLowerCase() + ">";
      }).replace(/<space>/ig, " ");
    },
    parseCustomKeyMappings: function(customKeyMappings) {
      var _, command, i, key, len, line, options, ref, results, tokens;
      ref = customKeyMappings.split("\n");
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        line = ref[i];
        if (!(line[0] === "\"" || line[0] === "#")) {
          tokens = line.replace(/\s+$/, "").split(/\s+/);
          switch (tokens[0]) {
            case "map":
              _ = tokens[0], key = tokens[1], command = tokens[2], options = 4 <= tokens.length ? slice.call(tokens, 3) : [];
              if ((command != null) && this.availableCommands[command]) {
                key = this.normalizeKey(key);
                console.log("Mapping", key, "to", command);
                results.push(this.mapKeyToCommand({
                  key: key,
                  command: command,
                  options: options
                }));
              } else {
                results.push(void 0);
              }
              break;
            case "unmap":
              if (tokens.length === 2) {
                key = this.normalizeKey(tokens[1]);
                console.log("Unmapping", key);
                results.push(delete this.keyToCommandRegistry[key]);
              } else {
                results.push(void 0);
              }
              break;
            case "unmapAll":
              results.push(this.keyToCommandRegistry = {});
              break;
            default:
              results.push(void 0);
          }
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    clearKeyMappingsAndSetDefaults: function() {
      var command, key, results;
      this.keyToCommandRegistry = {};
      results = [];
      for (key in defaultKeyMappings) {
        command = defaultKeyMappings[key];
        results.push(this.mapKeyToCommand({
          key: key,
          command: command
        }));
      }
      return results;
    },
    commandGroups: {
      pageNavigation: ["scrollDown", "scrollUp", "scrollLeft", "scrollRight", "scrollToTop", "scrollToBottom", "scrollToLeft", "scrollToRight", "scrollPageDown", "scrollPageUp", "scrollFullPageUp", "scrollFullPageDown", "reload", "toggleViewSource", "copyCurrentUrl", "LinkHints.activateModeToCopyLinkUrl", "openCopiedUrlInCurrentTab", "openCopiedUrlInNewTab", "goUp", "goToRoot", "enterInsertMode", "enterVisualMode", "enterVisualLineMode", "focusInput", "LinkHints.activateMode", "LinkHints.activateModeToOpenInNewTab", "LinkHints.activateModeToOpenInNewForegroundTab", "LinkHints.activateModeWithQueue", "LinkHints.activateModeToDownloadLink", "LinkHints.activateModeToOpenIncognito", "goPrevious", "goNext", "nextFrame", "mainFrame", "Marks.activateCreateMode", "Marks.activateGotoMode"],
      vomnibarCommands: ["Vomnibar.activate", "Vomnibar.activateInNewTab", "Vomnibar.activateTabSelection", "Vomnibar.activateBookmarks", "Vomnibar.activateBookmarksInNewTab", "Vomnibar.activateEditUrl", "Vomnibar.activateEditUrlInNewTab"],
      findCommands: ["enterFindMode", "performFind", "performBackwardsFind"],
      historyNavigation: ["goBack", "goForward"],
      tabManipulation: ["nextTab", "previousTab", "firstTab", "lastTab", "createTab", "duplicateTab", "removeTab", "restoreTab", "moveTabToNewWindow", "togglePinTab", "closeTabsOnLeft", "closeTabsOnRight", "closeOtherTabs", "moveTabLeft", "moveTabRight"],
      misc: ["showHelp"]
    },
    advancedCommands: ["scrollToLeft", "scrollToRight", "moveTabToNewWindow", "goUp", "goToRoot", "focusInput", "LinkHints.activateModeWithQueue", "LinkHints.activateModeToDownloadLink", "Vomnibar.activateEditUrl", "Vomnibar.activateEditUrlInNewTab", "LinkHints.activateModeToOpenIncognito", "goNext", "goPrevious", "Marks.activateCreateMode", "Marks.activateGotoMode", "moveTabLeft", "moveTabRight", "closeTabsOnLeft", "closeTabsOnRight", "closeOtherTabs"]
  };

  defaultKeyMappings = {
    "?": "showHelp",
    "j": "scrollDown",
    "k": "scrollUp",
    "h": "scrollLeft",
    "l": "scrollRight",
    "gg": "scrollToTop",
    "G": "scrollToBottom",
    "zH": "scrollToLeft",
    "zL": "scrollToRight",
    "<c-e>": "scrollDown",
    "<c-y>": "scrollUp",
    "d": "scrollPageDown",
    "u": "scrollPageUp",
    "r": "reload",
    "gs": "toggleViewSource",
    "i": "enterInsertMode",
    "v": "enterVisualMode",
    "V": "enterVisualLineMode",
    "H": "goBack",
    "L": "goForward",
    "gu": "goUp",
    "gU": "goToRoot",
    "gi": "focusInput",
    "f": "LinkHints.activateMode",
    "F": "LinkHints.activateModeToOpenInNewTab",
    "<a-f>": "LinkHints.activateModeWithQueue",
    "/": "enterFindMode",
    "n": "performFind",
    "N": "performBackwardsFind",
    "[[": "goPrevious",
    "]]": "goNext",
    "yy": "copyCurrentUrl",
    "yf": "LinkHints.activateModeToCopyLinkUrl",
    "p": "openCopiedUrlInCurrentTab",
    "P": "openCopiedUrlInNewTab",
    "K": "nextTab",
    "J": "previousTab",
    "gt": "nextTab",
    "gT": "previousTab",
    "<<": "moveTabLeft",
    ">>": "moveTabRight",
    "g0": "firstTab",
    "g$": "lastTab",
    "W": "moveTabToNewWindow",
    "t": "createTab",
    "yt": "duplicateTab",
    "x": "removeTab",
    "X": "restoreTab",
    "<a-p>": "togglePinTab",
    "o": "Vomnibar.activate",
    "O": "Vomnibar.activateInNewTab",
    "T": "Vomnibar.activateTabSelection",
    "b": "Vomnibar.activateBookmarks",
    "B": "Vomnibar.activateBookmarksInNewTab",
    "ge": "Vomnibar.activateEditUrl",
    "gE": "Vomnibar.activateEditUrlInNewTab",
    "gf": "nextFrame",
    "gF": "mainFrame",
    "m": "Marks.activateCreateMode",
    "`": "Marks.activateGotoMode"
  };

  commandDescriptions = {
    showHelp: [
      "显示帮助", {
        background: true
      }
    ],
    scrollDown: ["向下滚动"],
    scrollUp: ["向上滚动"],
    scrollLeft: ["向左滚动"],
    scrollRight: ["向右滚动"],
    scrollToTop: [
      "滚动到页面顶部", {
        noRepeat: true
      }
    ],
    scrollToBottom: [
      "滚动到页面底部", {
        noRepeat: true
      }
    ],
    scrollToLeft: [
      "一直向左滚动", {
        noRepeat: true
      }
    ],
    scrollToRight: [
      "一直向右滚动", {
        noRepeat: true
      }
    ],
    scrollPageDown: ["向下滚动半页"],
    scrollPageUp: ["向上滚动半页"],
    scrollFullPageDown: ["向下滚动整页"],
    scrollFullPageUp: ["向上滚动整页"],
    reload: [
      "刷新页面", {
        noRepeat: true
      }
    ],
    toggleViewSource: [
      "查看页面源代码", {
        noRepeat: true
      }
    ],
    copyCurrentUrl: [
      "复制当前页面URL到剪贴板", {
        noRepeat: true
      }
    ],
    "LinkHints.activateModeToCopyLinkUrl": [
      "复制一个链接的URL到剪贴板", {
        noRepeat: true
      }
    ],
    openCopiedUrlInCurrentTab: [
      "在当前标签页打开剪贴板中的URL", {
        background: true
      }
    ],
    openCopiedUrlInNewTab: [
      "在新标签页中打开剪贴板中的URL", {
        background: true,
        repeatLimit: 20
      }
    ],
    enterInsertMode: [
      "进入插入模式", {
        noRepeat: true
      }
    ],
    enterVisualMode: [
      "进入可视化模式 (实验特性)", {
        noRepeat: true
      }
    ],
    enterVisualLineMode: [
      "进入行可视化模式 (实验特性)", {
        noRepeat: true
      }
    ],
    focusInput: [
      "聚焦页面上的第一个文本框。使用Tab键在它们之间循环", {
        passCountToFunction: true
      }
    ],
    "LinkHints.activateMode": [
      "在当前标签页打开链接", {
        noRepeat: true
      }
    ],
    "LinkHints.activateModeToOpenInNewTab": [
      "在新标签页中打开链接", {
        noRepeat: true
      }
    ],
    "LinkHints.activateModeToOpenInNewForegroundTab": [
      "在新标签页中打开链接并切换过去", {
        noRepeat: true
      }
    ],
    "LinkHints.activateModeWithQueue": [
      "在新标签页中打开多个链接", {
        noRepeat: true
      }
    ],
    "LinkHints.activateModeToOpenIncognito": [
      "在隐身窗口中打开链接", {
        noRepeat: true
      }
    ],
    "LinkHints.activateModeToDownloadLink": [
      "下载链接URL", {
        noRepeat: true
      }
    ],
    enterFindMode: [
      "进入查找模式", {
        noRepeat: true
      }
    ],
    performFind: ["下一个查找匹配"],
    performBackwardsFind: ["上一个查找匹配"],
    goPrevious: [
      "打开标有上一页或者 < 的链接", {
        noRepeat: true
      }
    ],
    goNext: [
      "打开标有下一页或者 > 的链接", {
        noRepeat: true
      }
    ],
    goBack: [
      "后退", {
        passCountToFunction: true
      }
    ],
    goForward: [
      "前进", {
        passCountToFunction: true
      }
    ],
    goUp: [
      "转到上一层URL", {
        passCountToFunction: true
      }
    ],
    goToRoot: [
      "转到顶层URL", {
        passCountToFunction: true
      }
    ],
    nextTab: [
      "转到右侧标签页", {
        background: true,
        passCountToFunction: true
      }
    ],
    previousTab: [
      "转到左侧标签页", {
        background: true,
        passCountToFunction: true
      }
    ],
    firstTab: [
      "转到第一个标签页", {
        background: true,
        passCountToFunction: true
      }
    ],
    lastTab: [
      "转到最后一个标签页", {
        background: true,
        passCountToFunction: true
      }
    ],
    createTab: [
      "新建标签页", {
        background: true,
        repeatLimit: 20
      }
    ],
    duplicateTab: [
      "复制当前标签页", {
        background: true,
        repeatLimit: 20
      }
    ],
    removeTab: [
      "关闭当前标签页", {
        background: true,
        repeatLimit: (chrome.session ? chrome.session.MAX_SESSION_RESULTS : 25)
      }
    ],
    restoreTab: [
      "恢复关闭的标签页", {
        background: true,
        repeatLimit: 20
      }
    ],
    moveTabToNewWindow: [
      "移动标签页到新窗口", {
        background: true
      }
    ],
    togglePinTab: [
      "固定/取消固定当前标签页", {
        background: true
      }
    ],
    closeTabsOnLeft: [
      "关闭左侧标签页", {
        background: true,
        noRepeat: true
      }
    ],
    closeTabsOnRight: [
      "关闭右侧标签页", {
        background: true,
        noRepeat: true
      }
    ],
    closeOtherTabs: [
      "关闭所有其他标签页", {
        background: true,
        noRepeat: true
      }
    ],
    moveTabLeft: [
      "向左移动标签页", {
        background: true,
        passCountToFunction: true
      }
    ],
    moveTabRight: [
      "向右移动标签页", {
        background: true,
        passCountToFunction: true
      }
    ],
    "Vomnibar.activate": [
      "打开URL，书签或历史记录", {
        noRepeat: true
      }
    ],
    "Vomnibar.activateInNewTab": [
      "在新标签页中打开URL，书签或历史记录", {
        noRepeat: true
      }
    ],
    "Vomnibar.activateTabSelection": [
      "在打开的标签页中搜索", {
        noRepeat: true
      }
    ],
    "Vomnibar.activateBookmarks": [
      "打开书签", {
        noRepeat: true
      }
    ],
    "Vomnibar.activateBookmarksInNewTab": [
      "在新标签页中打开书签", {
        noRepeat: true
      }
    ],
    "Vomnibar.activateEditUrl": [
      "编辑当前URL", {
        noRepeat: true
      }
    ],
    "Vomnibar.activateEditUrlInNewTab": [
      "编辑当前URL并在新标签页中打开", {
        noRepeat: true
      }
    ],
    nextFrame: [
      "转到页面上的下一个框架", {
        background: true,
        passCountToFunction: true
      }
    ],
    mainFrame: [
      "选择标签的主/顶部框架", {
        background: true,
        noRepeat: true
      }
    ],
    "Marks.activateCreateMode": [
      "新建标记", {
        noRepeat: true
      }
    ],
    "Marks.activateGotoMode": [
      "转到标记", {
        noRepeat: true
      }
    ]
  };

  Commands.init();

  Settings.postUpdateHooks["keyMappings"] = function(value) {
    Commands.clearKeyMappingsAndSetDefaults();
    Commands.parseCustomKeyMappings(value);
    return refreshCompletionKeysAfterMappingSave();
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Commands = Commands;

}).call(this);
